#include "userprocess.h"
#include <stdio.h>
#include "Message.h"
#include "sn_debug.h"

User_Process::User_Process(int in_num_processes, int in_r)
{
	num_processes = in_num_processes;
	r = in_r;

	val_array = new int[num_processes + 1];
	level_array = new int[num_processes + 1];
}

void User_Process::Set_Start_State()
{
	int loop;

	i = process_id;
	rounds = 0;
	decision = UNKNOWN;
	key = UNDEFINED;

	for (loop = 1; loop <= num_processes; loop++)
	{
		if (loop != i)
		{
			val_array[loop] = UNDEFINED;
			level_array[loop] = -1;
		}
		else
		{
			val_array[loop] = 1;  // decision value
			/*if (i == 2)  // set a particular process's decision value to something else
				val_array[loop] = 0;*/
			level_array[loop] = 0;
		}
	}

	if (i == 1)
	{
		srand(1);
		key = (rand() % num_processes) + 1;
		key = 6;
	}
}

void User_Process::Generate_Messages()
{
	int loop;
	int inloop;

	map<Message *,int> outgoing_messages;

	// Remember process ids are 1 based!
	for (loop = 1; loop <= num_processes; loop++)
		if (loop != i)
		{
			Message* outgoing_message = new Message;
			for (inloop = 1; inloop <= num_processes; inloop++)
			{
				outgoing_message->L_array[inloop] = level_array[inloop];
				outgoing_message->V_array[inloop] = val_array[inloop];
			}
			outgoing_message->k = key;

			pair<Message *,int> msg_to_pair(outgoing_message, loop);
			outgoing_messages.insert(msg_to_pair);
		}

	// --------------------------------
	// Convert Messages to SN_Messages
	map<SN_Message *,int> outgoing_sn_messages;

	map<Message *,int>::iterator a_message;
	for (a_message = outgoing_messages.begin();a_message != outgoing_messages.end();
		a_message++)
	{
		SN_Message* sn_message_ptr = reinterpret_cast<SN_Message *> (a_message->first);
		outgoing_sn_messages.insert(make_pair(sn_message_ptr,a_message->second));
	}
	// --------------------------------

	Send(&outgoing_sn_messages);

	for (a_message = outgoing_messages.begin();a_message != outgoing_messages.end();
		a_message++)
	{
		delete (a_message->first);
	}
}

void User_Process::Transition(map<SN_Message*, int> inbound_sn_msgs)
{
	// -----------------------------------------------------------
	// First convert all the SN_Messages to our Messages
	map<Message *,int> inbound_msgs;
	map<SN_Message *,int>::iterator an_sn_msg;
	
	for(an_sn_msg = inbound_sn_msgs.begin();
		an_sn_msg != inbound_sn_msgs.end(); an_sn_msg++)
	{
		Message *a_msg = reinterpret_cast<Message *>(an_sn_msg->first);
		inbound_msgs.insert(make_pair(a_msg,an_sn_msg->second));
	}
	// -----------------------------------------------------------

	int loop;
	int min_level = UNDEFINED;

	rounds++;

	map<Message *, int>::iterator a_message;

	for (a_message = inbound_msgs.begin();a_message != inbound_msgs.end(); a_message++)
	{
		Message inbound_msg = *(a_message->first);
		// who is this message from?  if it's from us we can't use it
		DEBUG("Process %d: k = %d, l[1] = %d, l[2] = %d, v[1] = %d, v[2] = %d\n", i, inbound_msg.k, inbound_msg.L_array[1], inbound_msg.L_array[2], inbound_msg.V_array[1], inbound_msg.V_array[2]);
		if (inbound_msg.k != UNDEFINED)
			key = inbound_msg.k;
		for (loop = 1; loop <= num_processes; loop++)
		{
			if (inbound_msg.V_array[loop] != UNDEFINED)
				val_array[loop] = inbound_msg.V_array[loop];
			if (inbound_msg.L_array[loop] > level_array[loop])
				level_array[loop] = inbound_msg.L_array[loop];
		}
	}
	for (loop = 1; loop <= num_processes; loop++)
		if ((loop != i) && (level_array[loop] > min_level))
			min_level = level_array[loop];
	level_array[i] = min_level + 1;

	DEBUG_1("Process %d: received %d messages\n", i, inbound_msgs.size());

	DEBUG_2("Process %d: k = %d, level[%d] = %d\n", i, key, i, level_array[i]);

	if (rounds == r)
	{
		if ((key != UNDEFINED) && (level_array[i] > key))
		{
			decision = 1;
			for (loop = 1; loop <= num_processes; loop++)
				if (val_array[loop] != 1)
				{
					decision = 0;
					break;
				}
		}
		else
			decision = 0;

		DEBUG("-->PROCESS %d DECIDED %d...<--\n", i, decision);
	}
}
